---
title: Update nameservers · Cloudflare DNS docs
description: To use Cloudflare DNS as an authoritative DNS provider - be it in a
  primary (full) or secondary setup -, your domain nameservers must point to
  nameservers that you get from your Cloudflare account. Updating your
  nameservers is required to activate your domain on Cloudflare and use most of
  our application services.
lastUpdated: 2025-09-12T15:58:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/nameservers/update-nameservers/
  md: https://developers.cloudflare.com/dns/nameservers/update-nameservers/index.md
---

To use Cloudflare DNS as an authoritative DNS provider - be it in a [primary (full)](https://developers.cloudflare.com/dns/zone-setups/full-setup/) or [secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/) setup -, your domain nameservers must point to nameservers that you get from your Cloudflare account. Updating your nameservers is required to activate your domain on Cloudflare and use most of our [application services](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/).

## Specific processes

Although Cloudflare will [provide you the nameservers](https://developers.cloudflare.com/dns/nameservers/#authoritative-nameservers-offering) or allow you to create your own [custom nameservers](https://developers.cloudflare.com/dns/nameservers/custom-nameservers/), the final step to make Cloudflare an authoritative DNS provider for your domain may have to be done outside of Cloudflare. If you are not using [Cloudflare Registrar](https://developers.cloudflare.com/registrar/), consider which of the following sections correspond to your use case.

Custom or advanced nameservers

If you are using Cloudflare Registrar with [custom nameservers](https://developers.cloudflare.com/dns/nameservers/custom-nameservers/) or [advanced nameservers](https://developers.cloudflare.com/dns/foundation-dns/setup/), note that you must [reach out to support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) to have the nameservers updated accordingly.

### Your domain uses a different registrar

If you have acquired your domain from a [registrar](https://www.cloudflare.com/learning/dns/glossary/what-is-a-domain-name-registrar/) other than Cloudflare Registrar - and it has not been [delegated to another zone](#your-domain-is-delegated-to-another-zone) - you need to update your nameservers at your registrar.

Provider-specific instructions

This is not an exhaustive list of provider-specific instructions, but the following links may be helpful:

* [Ionos](https://www.ionos.com/help/domains/using-your-own-name-servers/using-your-own-name-servers-for-a-domain/)
* [101Domain](https://help.101domain.com/kb/managing-name-server-records)
* [Amazon](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-name-servers-glue-records.html#domain-name-servers-glue-records-adding-changing)
* [Blacknight](https://help.blacknight.com/hc/en-us/articles/212512229-Changing-nameservers-in-cp-blacknight-com)
* [BlueHost](https://www.bluehost.com/help/article/custom-nameservers)
* [DirectNIC](https://directnic.com/knowledge/article/33:how%2Bdo%2Bi%2Bmodify%2Bname%2Bservers%2Bfor%2Bmy%2Bdomain%2Bname%253F)
* [DNSMadeEasy](http://www.dnsmadeeasy.com/support/faq/)
* [Domain.com](https://www.domain.com/help/article/domain-management-how-to-update-nameservers)
* [Dotster](https://www.dotster.com/help/article/domain-management-how-to-update-nameservers)
* [DreamHost](https://help.dreamhost.com/hc/en-us/articles/360038897151)
* [EasyDNS](https://kb.easydns.com/knowledge/settingchanging-nameservers/)
* [Enom](https://help.enom.com/hc/en-us/articles/115000486451-Nameservers-NS)
* [Fast Domain](https://www.fastdomain.com/hosting/help/transfer_client_start)
* [FlokiNET](https://billing.flokinet.is/index.php?rp=/knowledgebase/57/Nameserver-and-DNS-records.html)
* [Gandi](https://docs.gandi.net/en/domain_names/common_operations/changing_nameservers.html)
* [GoDaddy](https://www.godaddy.com/help/change-nameservers-for-your-domain-names-664)
* [HostGator](https://www.hostgator.com/help/article/changing-name-servers)
* [Hostico](https://hostico.ro/docs/setarea-nameserverelor-din-contul-de-client-hostico/)
* [HostMonster](https://my.hostmonster.com/cgi/help/222)
* [Hover](https://support.hover.com/support/solutions/articles/201000064742-changing-your-domain-nameservers)
* [Internetdbs](https://faq.internetbs.net/hc/en-gb/articles/4516921367837-How-to-update-Nameservers-for-a-domain)
* [iPage](https://www.ipage.com/help/article/domain-management-how-to-update-nameservers)
* [MelbourneIT](https://support.melbourneit.au/docs/how-do-i-manage-my-dns-on-cpanel)
* [Moniker](https://support.moniker.com/hc/en-gb/articles/10101271418653-How-to-update-Nameservers-for-a-domain)
* [Name.com](https://www.name.com/support/articles/205934457-registering-custom-nameservers)
* [Namecheap](https://www.namecheap.com/support/knowledgebase/article.aspx/767/10/how-can-i-change-the-nameservers-for-my-domain)
* [Network Solutions](https://www.networksolutions.com/manage-it/edit-nameservers.jsp)
* [OVH](https://docs.ovh.com/gb/en/domains/web_hosting_general_information_about_dns_servers/#step-2-edit-your-domains-dns-servers)
* [Porkbun](https://kb.porkbun.com/article/22-how-to-change-your-nameservers)
* [Rackspace](https://support.rackspace.com/how-to/rackspace-name-servers/)
* [Register](https://www.register.com/knowledge)
* [Squarespace](https://support.squarespace.com/hc/articles/4404183898125-Nameservers-and-DNSSEC-for-Squarespace-managed-domains#toc-open-the-domain-s-advanced-settings)
* [Site5](https://kb.site5.com/dns-2/custom-nameservers/)
* [Softlayer](https://cloud.ibm.com/docs/dns?topic=dns-add-edit-or-delete-custom-name-servers-for-a-domain)
* [Yola](https://helpcenter.yola.com/hc/articles/360012492660-Changing-your-name-servers)

If you do not know who your registrar is, you can use a Whois search, such as [ICANN Lookup](https://lookup.icann.org/). If the registrar indicated on your Whois search result is not a service that you have interacted directly with, you may [have acquired your domain from a reseller](#you-have-acquired-your-domain-from-a-reseller).

### You have acquired your domain from a reseller

Some services, such as website builders ([Squarespace](https://support.squarespace.com/hc/articles/115003671428-Who-s-my-domain-provider), for example), are not registrars but act as a [reseller](https://www.icann.org/resources/pages/reseller-2013-05-03-en), allowing you to buy domains directly from them.

In that case, you may have to update your nameservers in the reseller platform, not at the registrar.

Note

Refer to [Squarespace documentation](https://support.squarespace.com/hc/articles/4404183898125-Nameservers-and-DNSSEC-for-Squarespace-managed-domains#toc-open-the-domain-s-advanced-settings) on how to update nameservers in their platform.

### Your domain is delegated to another zone

If you are onboarding a subdomain `shop.example.com` as a [child domain](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/), it is expected that the child domain has been delegated to the parent domain.

Delegation means that `shop.example.com` has specific `NS` records set up for it within the DNS records management of the parent zone (`example.com`).

If that is the case, when setting up your zone in Cloudflare or opting for a different set of [nameservers](https://developers.cloudflare.com/dns/nameservers/), you have to update the `NS` records in the parent domain, and not at the registrar.
